﻿// Copyright (c) 2025 SATO CORPORATION. All rights reserved.
// Use of this software is governed by the End User License Agreement (EULA) included with the distribution.
// For the latest version of the EULA, please visit our website.

using SATO.MLComponent;
using System;
using System.Collections; 
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        private MLComponent MLComponent;
        private ArrayList RecDatas;
        public Form1()

        {
            InitializeComponent();
        }
        private void Button1_Click_1(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "レイアウトファイル (*.mllayx)|*.mllayx|すべてのファイル (*.*)|*.*";
            openFileDialog1.FileName = "";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                LayoutFileName.Text = openFileDialog1.FileName;
            }
        }

        private void Button2_Click_1(object sender, EventArgs e)
        {
            openFileDialog1.Filter = "テキスト(タブ区切り) (*.txt)|*.txt|すべてのファイル (*.*)|*.*";
            openFileDialog1.FileName = "";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                DataFileName.Text = openFileDialog1.FileName;
            }
        }

        private void ReadDataFile()
        {
            Stream strm = null;
            strm = File.OpenRead(DataFileName.Text);
            StreamReader sr = new StreamReader(strm, Encoding.Default);

            sr.BaseStream.Seek(0, SeekOrigin.Begin);
            while ((sr.Peek() > -1))
            {
                RecDatas.Add(sr.ReadLine());
            }
            sr.Close();

        }

        private void Button3_Click_1(object sender, EventArgs e)
        {
            long ret = 0;
            //関数の実行結果
            long recNum = 0;
            //レコード番号
            try
            {
                //通信設定プロパティの設定
                MLComponent.Setting = Setting.Text;
                //タイムアウト値を設定（ここでは3秒）
                MLComponent.Timeout = 3;
                //通信プロトコルを設定
                if (Protocol.SelectedIndex == 0){
                    MLComponent.Protocol = Protocols.Status3;
                }
                else{
                    MLComponent.Protocol = Protocols.Status4;
                }
                //レイアウトファイルの設定
                MLComponent.LayoutFile = LayoutFileName.Text;
            }
            catch (Exception ex)
            {
                MessageBox.Show("プロパティ設定で例外発生 " + ex.Message);
                return;
            }
            ret = MLComponent.OpenPort(1);
            if (ret != 0)
            {
                MessageBox.Show("OpenPortでエラー発生, ret=" + ret);
                return;
            }
            //コレクションオブジェクト生成します。(データ格納用)
            RecDatas = new ArrayList();

            //ファイルからデータを読み込みます。
            ReadDataFile();

            if (ret != 0)
            {
                MessageBox.Show("Data File Read Error");
                return;
            }
            StatusText.Text = "";
            int recCount = 0;
            recCount = RecDatas.Count;
            for (recNum = 1; recNum <= recCount; recNum++)
            {
                //プリンタが受信可能になるまで待ちます。
                //本処理を省略すると、紙切れやエラー時にデータを送信し、ラベル抜けが発生します。
                //データ送信前の状態確認は必ず行い、運用に応じて送信後の状態確認も行ってください。
                if (PrinterReadyWait() == false)
                {
                    MLComponent.ClosePort();
                    return;
                }
                //発行します。
                MLComponent.PrnData = (String)RecDatas[(int)recNum-1];

                StatusText.Text = "印字中";
                ret = MLComponent.Output();
                if (ret != 0)
                {
                    MLComponent.ClosePort();
                    MessageBox.Show("Output Error, ret=" + ret);
                    return;
                }
                Application.DoEvents();
            }
            //データ格納用コレクションオブジェクトを破棄します。
            RecDatas = null;
            //印字が完了するまでWait
            PrinterReadyWait();
            MLComponent.ClosePort();
            StatusText.Text = "";
        }

        private Boolean PrinterReadyWait()
        {
            string Status = null;
            int ret = 0;
            //関数の実行結果
            string strSetting = null;
            strSetting = MLComponent.Setting.Substring(0, 4);
            //出力先がドライバの場合ステータスチェックを行わない
            if ((strSetting != "DRV:") & (strSetting != "FILE"))
            {
                Status = "";

                while ((Status != "A000000") & (Status != "B000000"))
                {
                    ret = MLComponent.GetStatus(ref Status);
                    if (ret == 0)
                    {
                        StatusText.Text = Status;
                    }
                    else
                    {
                        MessageBox.Show("ステータス応答がありません。ret=" + ret);
                        return false;
                    }
                    //受信ステータスからステータスと残り枚数の部分を取り出す
                    Status = Status.Substring(2, 7);                
                    Application.DoEvents();
                }
            }
            return true;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //MLComponent生成
            Encoding.RegisterProvider(CodePagesEncodingProvider.Instance);
            MLComponent = new MLComponent();
            
            //コンボボックスに通信設定例を列挙します。
        	Setting.Items.Add(("LAN:192.168.1.10,9100"));
        	Setting.Items.Add(("USB:"));
        	Setting.Items.Add(("COM1:57600,n,8,1"));
        	Setting.Items.Add(("BT:000b5d3db4c2"));
        	Setting.Items.Add(("DRV:SATO CL4NX-J 305dpi"));
        	Setting.Items.Add(("FILE:C:\\sato\\print.prn,0"));
        	Setting.Text = MLComponent.Setting;

            //コンボボックスにプロトコルを列挙します。
            Protocol.Items.Add(("0 - Status3"));
            Protocol.Items.Add(("1 - Status4"));
            Protocol.SelectedIndex = 1;

            this.Text = "Printing Sample (" + MLComponent.Version + ")";
        }
    }
}
