﻿using System;
using System.Text;
using System.Windows.Forms;
using SATO.MLComponent;
using System.Drawing;

namespace MLComponentSample
{
    public partial class Form1 : Form
    {
        private MLComponent MLComponent;
        public Form1()
        {
            InitializeComponent();
        }
     
        private void Form1_Load(System.Object sender, System.EventArgs e)
        {
            //MLComponent生成
            MLComponent = new MLComponent();

            //コンボボックスに通信設定例を列挙します。
            Setting.Items.Add(("LAN:127.0.0.1"));
            Setting.Items.Add(("USB:"));
            Setting.Items.Add(("COM1:57600,n,8,1"));
            Setting.Items.Add(("BT:000b5d3db4c2"));
            Setting.Items.Add(("DRV:SATO CL4NX-J 305dpi"));
            Setting.Items.Add(("FILE:C:\\sato\\print.prn,0"));

            //コンボボックスにプロトコルを列挙します。
            Protocol.Items.Add(("0 - Status3"));
            Protocol.Items.Add(("1 - Status4"));

            //コンボボックスに印字データタイプを列挙します。
            PrnDataType.Items.Add(("0 - Tsv"));
            PrnDataType.Items.Add(("1 - Csv"));
            PrnDataType.Items.Add(("2 - Prn"));

            //コンボボックスにカット指定を列挙します。
            MultiCut.Items.Add(("レイアウト"));
            MultiCut.Items.Add(("プリンタ"));
            MultiCut.Items.Add(("なし"));
            MultiCut.Items.Add(("枚数指定"));

            //コンボボックスにフォームオーバーレイを列挙します。
            Formoverlay.Items.Add(("0 - None"));
            Formoverlay.Items.Add(("1 - Save"));
            Formoverlay.Items.Add(("2 - Load"));
            Formoverlay.Items.Add(("3 - Layout"));

            //プロパティを画面に表示します。

            //通信設定
            Setting.Text = MLComponent.Setting;
            Protocol.SelectedIndex = (int)MLComponent.Protocol;
            Timeout.Text = Convert.ToString(MLComponent.Timeout);
            StatusID.Text = Convert.ToString(MLComponent.StatusID);
            JobName.Text = MLComponent.JobName;

            //基本設定
            LayoutFile.Text = MLComponent.LayoutFile;
            PrnData.Text = MLComponent.PrnData;
            PrnDataType.SelectedIndex = (int)MLComponent.PrnDataType;

            //プリンタ動作設定
            Darkness.Text = MLComponent.Darkness;
            Speed.Text = MLComponent.Speed;
            Offset.Text = MLComponent.Offset;
            if ((MLComponent.MultiCut > 0))
            {
                MultiCut.SelectedIndex = 3;
                MultiCutQty.Text = MLComponent.MultiCut.ToString();
            }
            else
            {
                MultiCut.SelectedIndex = (int)MLComponent.MultiCut + 2;
                MultiCutQty.Text = "";
            }
            SortMark.Checked = MLComponent.SortMark;
            EjectCut.Checked = MLComponent.EjectCut;
            HeaderTailSetting.Checked = MLComponent.HeaderTailSetting;
            HeaderFile.Text = MLComponent.HeaderFile;
            TailFile.Text = MLComponent.TailFile;

            //特殊設定
            Formoverlay.SelectedIndex = (int)MLComponent.Formoverlay;
            LayoutNameCaption.Text = MLComponent.LayoutNameCaption;
            TotalQtyCaption.Text = MLComponent.TotalQtyCaption.ToString();
            TaxRate.Text = MLComponent.TaxRate;

            //バージョン
            Version.Text = MLComponent.Version;

            //ボタンにアイコンを表示
            Bitmap canvas = new Bitmap(DataInfo.Width, DataInfo.Height);
            Graphics g = Graphics.FromImage(canvas);
            Image img = SystemIcons.Exclamation.ToBitmap();
            g.DrawImage(img, 5, 4, DataInfo.Width  - 10, DataInfo.Height - 10);
            g.Dispose();
            DataInfo.Image = canvas;

            //SendStringData/SendRawData設定
            cmbType.Items.Add(("0 - 文字列"));
            cmbType.Items.Add(("1 - バイト"));
            cmbType.Items.Add(("2 - 16進文字コード"));
            cmbType.SelectedIndex = 0;
            txtLength.Text = "0";
        }


        private void Form1_FormClosed(System.Object sender, System.Windows.Forms.FormClosedEventArgs e)
        {
            //ポートを閉じる
            MLComponent.ClosePort();

        }


        private void LayoutFile_Leave(System.Object sender, System.EventArgs e)
        {
            if (LayoutFile.Text != MLComponent.LayoutFile)
            {
                MLComponent.LayoutFile = LayoutFile.Text;
                HeaderFile.Text = MLComponent.HeaderFile;
                TailFile.Text = MLComponent.TailFile;
            }

        }


        private void LayoutFileButton_Click(object sender, EventArgs e)
        {
            OpenFileDialog1.Filter = "レイアウトファイル (*.mllayx)|*.mllayx|すべてのファイル (*.*)|*.*";
            OpenFileDialog1.FileName = "";
            if (OpenFileDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                LayoutFile.Text = OpenFileDialog1.FileName;
                MLComponent.LayoutFile = OpenFileDialog1.FileName;
                HeaderFile.Text = MLComponent.HeaderFile;
                TailFile.Text = MLComponent.TailFile;
            }

        }


        private void OpenPortButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "OpenPort";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            try
            {
                //通信設定プロパティの設定
                MLComponent.Setting = Setting.Text;
                //プロトコルプロパティの設定
                MLComponent.Protocol = (Protocols)Protocol.SelectedIndex;
                //タイムアウトプロパティの設定
                MLComponent.Timeout = Int32.Parse(Timeout.Text);
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //ポートを開く
            Result = MLComponent.OpenPort(1);

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("OpenPortでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("OpenPort成功");
            }

        }


        private void ClosePortButton_Click(object sender, EventArgs e)
        {
            MethodName.Text = "ClosePort";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //ポートを閉じる
            Result = MLComponent.ClosePort();

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("ClosePortでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("ClosePort成功");
            }

        }


        private void OutputButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "Output";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //プロパティ設定
            try
            {
                //ステータスIDを設定します。
                MLComponent.StatusID = Int32.Parse(StatusID.Text);
                //ジョブ名を設定します。
                MLComponent.JobName = JobName.Text;
                //印字濃度を設定します。
                MLComponent.Darkness = Darkness.Text;
                //印字速度を設定します。
                MLComponent.Speed = Speed.Text;
                //印字補正プロパティを設定します。
                MLComponent.Offset = Offset.Text;
                //カット指定を設定します。
                if (MultiCut.SelectedIndex == 3)
                {
                    MLComponent.MultiCut = Int32.Parse(MultiCutQty.Text);
                }
                else
                {
                    MLComponent.MultiCut = MultiCut.SelectedIndex - 2;
                }
                //仕分けマークの印字を設定します。
                MLComponent.SortMark = SortMark.Checked;
                //排出カットの印字を設定します。
                MLComponent.EjectCut = EjectCut.Checked;
                //ヘッダ・テール札の印字有無を設定します。
                MLComponent.HeaderTailSetting = HeaderTailSetting.Checked;
                //フォームオーバーレイを設定します。
                MLComponent.Formoverlay = (FormoverlayTypes)Formoverlay.SelectedIndex;
                //レイアウト名を設定します。 
                MLComponent.LayoutNameCaption = LayoutNameCaption.Text;
                //総発行枚数を設定します。
                MLComponent.TotalQtyCaption = Int32.Parse(TotalQtyCaption.Text);
                //税率を設定します。
                MLComponent.TaxRate = TaxRate.Text;
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
                //印字データタイプを設定します。
                MLComponent.PrnDataType = (PrnDataTypes)PrnDataType.SelectedIndex;
                //印字データを設定します。
                MLComponent.PrnData = PrnData.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //ラベル・タグを発行
            Result = MLComponent.Output();

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("Outputでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("Output成功");
            }

        }


        private void OutputHeaderButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "OutputHeader";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //プロパティ設定
            try
            {
                //ステータスIDを設定します。
                MLComponent.StatusID = Int32.Parse(StatusID.Text);
                //ジョブ名を設定します。
                MLComponent.JobName = JobName.Text;
                //印字濃度を設定します。
                MLComponent.Darkness = Darkness.Text;
                //印字速度を設定します。
                MLComponent.Speed = Speed.Text;
                //印字補正プロパティを設定します。
                MLComponent.Offset = Offset.Text;
                //カット指定を設定します。
                if (MultiCut.SelectedIndex == 3)
                {
                    MLComponent.MultiCut = Int32.Parse(MultiCutQty.Text);
                }
                else
                {
                    MLComponent.MultiCut = MultiCut.SelectedIndex - 2;
                }
                //仕分けマークの印字を設定します。
                MLComponent.SortMark = SortMark.Checked;
                //排出カットの印字を設定します。
                MLComponent.EjectCut = EjectCut.Checked;
                //ヘッダ・テール札の印字有無を設定します。
                MLComponent.HeaderTailSetting = HeaderTailSetting.Checked;
                //フォームオーバーレイを設定します。
                MLComponent.Formoverlay = (FormoverlayTypes)Formoverlay.SelectedIndex;
                //レイアウト名を設定します。
                MLComponent.LayoutNameCaption = LayoutNameCaption.Text;
                //総発行枚数を設定します。
                MLComponent.TotalQtyCaption = Int32.Parse(TotalQtyCaption.Text);
                //税率を設定します。
                MLComponent.TaxRate = TaxRate.Text;
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
                //印字データタイプを設定します。
                MLComponent.PrnDataType = (PrnDataTypes)PrnDataType.SelectedIndex;
                //印字データを設定します。
                MLComponent.PrnData = PrnData.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //ヘッダ札を発行
            Result = MLComponent.OutputHeader();

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("OutputHeaderでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("OutputHeader成功");
            }

        }


        private void OutputTailButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "OutputTail";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //プロパティ設定
            try
            {
                //ステータスIDを設定します。
                MLComponent.StatusID = Int32.Parse(StatusID.Text);
                //ジョブ名を設定します。
                MLComponent.JobName = JobName.Text;
                //印字濃度を設定します。
                MLComponent.Darkness = Darkness.Text;
                //印字速度を設定します。
                MLComponent.Speed = Speed.Text;
                //印字補正プロパティを設定します。
                MLComponent.Offset = Offset.Text;
                //カット指定を設定します。
                if (MultiCut.SelectedIndex == 3)
                {
                    MLComponent.MultiCut = Int32.Parse(MultiCutQty.Text);
                }
                else
                {
                    MLComponent.MultiCut = MultiCut.SelectedIndex - 2;
                }
                //仕分けマークの印字を設定します。
                MLComponent.SortMark = SortMark.Checked;
                //排出カットの印字を設定します。
                MLComponent.EjectCut = EjectCut.Checked;
                //ヘッダ・テール札の印字有無を設定します。
                MLComponent.HeaderTailSetting = HeaderTailSetting.Checked;
                //フォームオーバーレイを設定します。
                MLComponent.Formoverlay = (FormoverlayTypes)Formoverlay.SelectedIndex;
                //レイアウト名を設定します。
                MLComponent.LayoutNameCaption = LayoutNameCaption.Text;
                //総発行枚数を設定します。
                MLComponent.TotalQtyCaption = Int32.Parse(TotalQtyCaption.Text);
                //税率を設定します。
                MLComponent.TaxRate = TaxRate.Text;
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
                //印字データタイプを設定します。
                MLComponent.PrnDataType = (PrnDataTypes)PrnDataType.SelectedIndex;
                //印字データを設定します。
                MLComponent.PrnData = PrnData.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //テール札を発行
            Result = MLComponent.OutputTail();

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("OutputTailでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("OutputTail成功");
            }

        }


        private void SendStringDataButton_Click(object sender, EventArgs e)
        {
            int Type = cmbType.SelectedIndex;
            int Length = 0;
            string EndChar = txtEndChar.Text;
            try
            {
                Length = int.Parse(txtLength.Text);
                if ((Length < 0))
                {
                    throw new ArgumentException();
                }
            }
            catch (Exception)
            {
                MessageBox.Show("バイト数の指定に誤りがあります。", "パラメータエラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            //初期化
            MethodName.Text = "SendStringData";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            object Result = null;
            string Command = txtSendData.Text;

            //SBPLコマンドの送信
            try
            {
                Result = MLComponent.SendStringData(Type, Command, Length, EndChar);
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("SendStringDataでエラー発生");
                MessageList.Items.Add(ex.Message.Replace("\r\n", " "));
                return;
            }

            MessageList.Items.Add("SendStringData成功");
            if (Result is string)
            {
                string RecvData = Convert.ToString(Result);
                MessageList.Items.Add("取得データは[" + RecvData + "]です。");
            }
            else if (Result is byte[])
            {
                byte[] RecvByte = (byte[])Result;
                string RecvData = "";
                foreach (byte Item in RecvByte)
                {
                    if (Item.ToString("X").Length == 1)
                    {
                        RecvData = RecvData + "0";
                    }
                    RecvData = RecvData + Item.ToString("X");
                }
                MessageList.Items.Add("取得データは[" + RecvData + "]です。");
            }

        }


        private void SendRawDataButton_Click(object sender, EventArgs e)
        {
            int Type = cmbType.SelectedIndex;
            int Length = 0;
            string EndChar = Encoding.ASCII.GetString(FromHexString(txtEndChar.Text));
            try
            {
                Length = int.Parse(txtLength.Text);
                if ((Length < 0))
                {
                    throw new ArgumentException();
                }
            }
            catch (Exception )
            {
                MessageBox.Show("バイト数の指定に誤りがあります。", "パラメータエラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            //初期化
            MethodName.Text = "SendRawData";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            object Result = null;
            byte[] Command = FromHexString(txtSendData.Text);

            //SBPLコマンドの送信
            try
            {
                Result = MLComponent.SendRawData((int)Type, ref Command, Length, EndChar);
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("SendRawDataでエラー発生");
                MessageList.Items.Add(ex.Message.Replace("\r\n", " "));
                return;
            }

            MessageList.Items.Add("SendRawData成功");
            if (Result is string)
            {
                string RecvData = Convert.ToString(Result);
                MessageList.Items.Add("取得データは[" + RecvData + "]です。");
            }
            else if (Result is byte[])
            {
                byte[] RecvByte = (byte[])(Result);
                string RecvData = "";
                foreach (byte Item in RecvByte)
                {
                    if (Item.ToString("X").Length == 1)
                    {
                        RecvData = RecvData + "0";
                    }
                    RecvData = RecvData + Item.ToString("X");
                }
                MessageList.Items.Add("取得データは[" + RecvData + "]です。");
            }

        }

        public static byte[] FromHexString(string str)
        {
            int length = str.Length / 2;
            byte[] bytes = new byte[length];
            int j = 0;
            for (int i = 0; i < length; i++)
            {
                bytes[i] = Convert.ToByte(str.Substring(j, 2), 16);
                j += 2;
            }
            return bytes;
        }

        private void GetStatusButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "GetStatus";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;
            string Status = "";

            //プリンタの状態確認
            Result = MLComponent.GetStatus(ref Status);

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("GetStatusでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("ステータスは[" + Status + "]です。");
            }

        }


        private void CutButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "Cut";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //プロパティ設定
            try
            {
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //用紙の排出カット
            Result = MLComponent.Cut();

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("Cutでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("Cut成功");
            }

        }


        private void SendCancelButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "SendCancel";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //発行のキャンセル
            Result = MLComponent.SendCancel();

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("SendCancelでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("SendCancel成功");
            }

        }


        private void GetInputFieldsButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "GetInputFields";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;
            int InputCount = 0;
            object InputStatus = null;

            //プロパティ設定
            try
            {
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //入力情報を取得
            Result = MLComponent.GetInputFields(ref InputCount,ref InputStatus);

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("GetInputFieldsでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("項目数は[" + Convert.ToString(InputCount) + "]です。");
                if (InputStatus is string[])
                {
                    string[] Fields = (string[])InputStatus;
                    foreach (string Item in Fields)
                    {
                        MessageList.Items.Add(Item);
                    }
                }
            }

        }


        private void SetPrnDataButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "SetPrnDataField";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;

            //プロパティ設定
            try
            {
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //印字データを設定
            //当サンプル「layout1.mllayx」の場合の記述例です。ご利用のレイアウトに合わせて書き換えてください。
            Result = MLComponent.SetPrnDataField("入力-1", "ABC");

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("SetPrnDataFieldでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("SetPrnDataField成功");
            }

        }


        private void SetPrnDataArrayButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "SetPrnDataArray";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result = 0;
            string[] PrnDataArray = null;

            //プロパティ設定
            try
            {
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            string Separator = "\t";
            if (PrnDataType.SelectedIndex == 1)
            {
                Separator = ",";
            }
            else if (PrnDataType.SelectedIndex == 2)
            {
                Separator = " ";
            }

            //以下の例は当サンプル「layout1.mllayx」の場合の記述例です。ご利用のレイアウトに合わせて書き換えてください。
            PrnDataArray = new string[3];
            PrnDataArray[0] = "ABC" + Separator + "1";
            PrnDataArray[1] = "EFG" + Separator + "1";
            PrnDataArray[2] = "123" + Separator + "2";

            //印字データを設定
            Result = MLComponent.SetPrnDataArray(ref PrnDataArray);

            MethodResult.Text = Convert.ToString(Result);

            if (Result != 0)
            {
                //失敗
                MessageList.Items.Add("SetPrnDataArrayでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("SetPrnDataArray成功");
            }

        }


        private void GetPrnDataArrayButton_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "GetPrnDataArray";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            string[] PrnDataArray = null;

            //印字データを取得
            PrnDataArray = MLComponent.GetPrnDataArray();

            if ((PrnDataArray == null))
            {
                //失敗
                MessageList.Items.Add("GetPrnDataArrayでエラー発生");
            }
            else if (PrnDataArray.Length == 0)
            {
                //失敗
                MessageList.Items.Add("GetPrnDataArrayでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("データ数は[" + Convert.ToString(PrnDataArray.Length) + "]です。");
                foreach (string Item in PrnDataArray)
                {
                    MessageList.Items.Add(Item);
                }
            }

        }


        private void GetPrinter_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "GetPrinter";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            string PrinterModel = null;

            //プロパティ設定
            try
            {
                //レイアウトファイルを設定します。
                MLComponent.LayoutFile = LayoutFile.Text;
            }
            catch (Exception ex)
            {
                MessageList.Items.Add("プロパティ設定で例外発生 " + ex.Message.Replace("\r\n", " "));
                return;
            }

            //プリンタ情報を取得
            PrinterModel = MLComponent.GetPrinter();

            if (string.IsNullOrEmpty(PrinterModel))
            {
                //失敗
                MessageList.Items.Add("GetPrinterでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("プリンタは[" + PrinterModel + "]です。");
            }

        }

        private void DataInfo_Click(object sender, EventArgs e)
        {
            string message = "";
            message += "送信データ・受信終了キャラクタは以下の形式で指定してください。" + Environment.NewLine;
            message += "SendStringData：文字列" + Environment.NewLine;
            message += "SendRawData：16進文字列" + Environment.NewLine + Environment.NewLine;
            message += "例：文字列[0310]は、16進文字列[30333130]です。";
            MessageBox.Show(message, "[SendStringData/SendRawData]", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
        }

        private void btnSearchBTDevice_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "EnumerateBluetoothDevices";
            MethodResult.Text = "";
            MessageList.Items.Clear();
            cmbBTDevice.Items.Clear();

            object arrayVar;
            int SearchTime = 3;

            MessageList.Items.Add("=====デバイス検索開始=====");
            Application.DoEvents();

            //Bluetoothデバイス検索
            arrayVar = MLComponent.EnumerateBluetoothDevices(SearchTime);

            object[,] DevArray = ((object[,])(arrayVar));
            for (int n = DevArray.GetLowerBound(0); (n <= DevArray.GetUpperBound(0)); n++)
            {
                string address = ((string)(DevArray[n, 0]));
                string name = ((string)(DevArray[n, 1]));
                string isauth = ((string)(DevArray[n, 2]));
                MessageList.Items.Add(" " + address + ", " + name + ", " + isauth);
                cmbBTDevice.Items.Add(address);
            }

            MessageList.Items.Add("=====デバイス検索終了=====");
        }

        private void btnPairingBTDevice_Click(object sender, EventArgs e)
        {
            //初期化
            MethodName.Text = "AuthenticateBluetoothDevice";
            MethodResult.Text = "";
            MessageList.Items.Clear();

            int Result;
            string Address = cmbBTDevice.Text;
            string PIN = PINCode.Text;
            int SearchTime = 3;
            
            // Bluetoothデバイスペアリング
            Result = MLComponent.AuthenticateBluetoothDevice(Address, PIN, SearchTime);
            MethodResult.Text = Result.ToString();
            if ((Result != 0))
            {
                //失敗
                MessageList.Items.Add("AuthenticateBluetoothDeviceでエラー発生");
            }
            else
            {
                //成功
                MessageList.Items.Add("AuthenticateBluetoothDevice成功");
            }
        }

    }
}
