﻿Imports System.Text
Imports SATO.MLComponent

Public Class Form1

    'MLComponent宣言
    Private MLComponent As MLComponent

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'MLComponent生成
        MLComponent = New MLComponent

        'コンボボックスに通信設定例を列挙します。
        Setting.Items.Add(("LAN:127.0.0.1"))
        Setting.Items.Add(("USB:"))
        Setting.Items.Add(("COM1:57600,n,8,1"))
        Setting.Items.Add(("BT:000b5d3db4c2"))
        Setting.Items.Add(("DRV:SATO CL4NX-J 305dpi"))
        Setting.Items.Add(("FILE:C:\sato\print.prn,0"))

        'コンボボックスにプロトコルを列挙します。
        Protocol.Items.Add(("0 - Status3"))
        Protocol.Items.Add(("1 - Status4"))

        'コンボボックスに印字データタイプを列挙します。
        PrnDataType.Items.Add(("0 - Tsv"))
        PrnDataType.Items.Add(("1 - Csv"))
        PrnDataType.Items.Add(("2 - Prn"))

        'コンボボックスにカット指定を列挙します。
        MultiCut.Items.Add(("レイアウト"))
        MultiCut.Items.Add(("プリンタ"))
        MultiCut.Items.Add(("なし"))
        MultiCut.Items.Add(("枚数指定"))

        'コンボボックスにフォームオーバーレイを列挙します。
        Formoverlay.Items.Add(("0 - None"))
        Formoverlay.Items.Add(("1 - Save"))
        Formoverlay.Items.Add(("2 - Load"))
        Formoverlay.Items.Add(("3 - Layout"))

        'プロパティを画面に表示します。

        '通信設定
        Setting.Text = MLComponent.Setting
        Protocol.SelectedIndex = CInt(MLComponent.Protocol)
        Timeout.Text = CStr(MLComponent.Timeout)
        StatusID.Text = CStr(MLComponent.StatusID)
        JobName.Text = MLComponent.JobName

        '基本設定
        LayoutFile.Text = MLComponent.LayoutFile
        PrnData.Text = MLComponent.PrnData
        PrnDataType.SelectedIndex = MLComponent.PrnDataType

        'プリンタ動作設定
        Darkness.Text = MLComponent.Darkness
        Speed.Text = MLComponent.Speed
        Offset.Text = MLComponent.Offset
        If (MLComponent.MultiCut > 0) Then
            MultiCut.SelectedIndex = 3
            MultiCutQty.Text = MLComponent.MultiCut.ToString()
        Else

            MultiCut.SelectedIndex = CInt(MLComponent.MultiCut) + 2
            MultiCutQty.Text = ""
        End If
        SortMark.Checked = MLComponent.SortMark
        EjectCut.Checked = MLComponent.EjectCut
        HeaderTailSetting.Checked = MLComponent.HeaderTailSetting
        HeaderFile.Text = MLComponent.HeaderFile
        TailFile.Text = MLComponent.TailFile

        '特殊設定
        Formoverlay.SelectedIndex = CInt(MLComponent.Formoverlay)
        LayoutNameCaption.Text = MLComponent.LayoutNameCaption
        TotalQtyCaption.Text = MLComponent.TotalQtyCaption.ToString()
        TaxRate.Text = MLComponent.TaxRate

        'バージョン
        Version.Text = MLComponent.Version

        'ボタンにアイコンを表示
        Dim canvas As New Bitmap(DataInfo.Width, DataInfo.Height)
        Dim g As Graphics = Graphics.FromImage(canvas)
        Dim img As Image = SystemIcons.Exclamation.ToBitmap
        g.DrawImage(img, 5, 4, DataInfo.Width - 10, DataInfo.Height - 10)
        g.Dispose()
        DataInfo.Image = canvas

        'SendStringData/SendRawData設定
        cmbType.Items.Add(("0 - 文字列"))
        cmbType.Items.Add(("1 - バイト"))
        cmbType.Items.Add(("2 - 16進文字コード"))
        cmbType.SelectedIndex = 0
        txtLength.Text = "0"

    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        'ポートを閉じる
        MLComponent.ClosePort()

    End Sub

    Private Sub LayoutFile_Leave(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LayoutFile.Leave

        If LayoutFile.Text <> MLComponent.LayoutFile Then
            On Error Resume Next
            MLComponent.LayoutFile = LayoutFile.Text
            HeaderFile.Text = MLComponent.HeaderFile
            TailFile.Text = MLComponent.TailFile
        End If

    End Sub

    Private Sub LayoutFileButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LayoutFileButton.Click

        OpenFileDialog1.Filter = "レイアウトファイル (*.mllayx)|*.mllayx|すべてのファイル (*.*)|*.*"
        OpenFileDialog1.FileName = ""
        If OpenFileDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            On Error Resume Next
            LayoutFile.Text = OpenFileDialog1.FileName
            MLComponent.LayoutFile = OpenFileDialog1.FileName
            HeaderFile.Text = MLComponent.HeaderFile
            TailFile.Text = MLComponent.TailFile
        End If

    End Sub

    Private Sub OpenPortButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OpenPortButton.Click

        '初期化
        MethodName.Text = "OpenPort"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        Try
            '通信設定プロパティの設定
            MLComponent.Setting = Setting.Text
            'プロトコルプロパティの設定
            MLComponent.Protocol = CType(CInt(Protocol.SelectedIndex), Protocols)
            'タイムアウトプロパティの設定
            MLComponent.Timeout = CInt(Timeout.Text)
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        'ポートを開く
        Result = MLComponent.OpenPort(1)

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("OpenPortでエラー発生")
        Else
            '成功
            MessageList.Items.Add("OpenPort成功")
        End If

    End Sub

    Private Sub ClosePortButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClosePortButton.Click

        MethodName.Text = "ClosePort"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        'ポートを閉じる
        Result = MLComponent.ClosePort()

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("ClosePortでエラー発生")
        Else
            '成功
            MessageList.Items.Add("ClosePort成功")
        End If

    End Sub

    Private Sub OutputButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OutputButton.Click

        '初期化
        MethodName.Text = "Output"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        'プロパティ設定
        Try
            'ステータスIDを設定します。
            MLComponent.StatusID = CInt(StatusID.Text)
            'ジョブ名を設定します。
            MLComponent.JobName = JobName.Text
            '印字濃度を設定します。
            MLComponent.Darkness = Darkness.Text
            '印字速度を設定します。
            MLComponent.Speed = Speed.Text
            '印字補正プロパティを設定します。
            MLComponent.Offset = Offset.Text
            'カット指定を設定します。
            If MultiCut.SelectedIndex = 3 Then
                MLComponent.MultiCut = CInt(MultiCutQty.Text)
            Else
                MLComponent.MultiCut = MultiCut.SelectedIndex - 2
            End If
            '仕分けマークの印字を設定します。
            MLComponent.SortMark = SortMark.Checked
            '排出カットの印字を設定します。
            MLComponent.EjectCut = EjectCut.Checked
            'ヘッダ・テール札の印字有無を設定します。
            MLComponent.HeaderTailSetting = HeaderTailSetting.Checked
            'フォームオーバーレイを設定します。
            MLComponent.Formoverlay = CType(Formoverlay.SelectedIndex, FormoverlayTypes)
            'レイアウト名を設定します。
            MLComponent.LayoutNameCaption = LayoutNameCaption.Text
            '総発行枚数を設定します。
            MLComponent.TotalQtyCaption = CInt(TotalQtyCaption.Text)
            '税率を設定します。
            MLComponent.TaxRate = TaxRate.Text
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
            '印字データタイプを設定します。
            MLComponent.PrnDataType = CType(PrnDataType.SelectedIndex, PrnDataTypes)
            '印字データを設定します。
            MLComponent.PrnData = PrnData.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        'ラベル・タグを発行
        Result = MLComponent.Output()

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("Outputでエラー発生")
        Else
            '成功
            MessageList.Items.Add("Output成功")
        End If

    End Sub

    Private Sub OutputHeaderButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OutputHeaderButton.Click

        '初期化
        MethodName.Text = "OutputHeader"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        'プロパティ設定
        Try
            'ステータスIDを設定します。
            MLComponent.StatusID = CInt(StatusID.Text)
            'ジョブ名を設定します。
            MLComponent.JobName = JobName.Text
            '印字濃度を設定します。
            MLComponent.Darkness = Darkness.Text
            '印字速度を設定します。
            MLComponent.Speed = Speed.Text
            '印字補正プロパティを設定します。
            MLComponent.Offset = Offset.Text
            'カット指定を設定します。
            If MultiCut.SelectedIndex = 3 Then
                MLComponent.MultiCut = CInt(MultiCutQty.Text)
            Else
                MLComponent.MultiCut = MultiCut.SelectedIndex - 2
            End If
            '仕分けマークの印字を設定します。
            MLComponent.SortMark = SortMark.Checked
            '排出カットの印字を設定します。
            MLComponent.EjectCut = EjectCut.Checked
            'ヘッダ・テール札の印字有無を設定します。
            MLComponent.HeaderTailSetting = HeaderTailSetting.Checked
            'フォームオーバーレイを設定します。
            MLComponent.Formoverlay = CType(Formoverlay.SelectedIndex, FormoverlayTypes)
            'レイアウト名を設定します。
            MLComponent.LayoutNameCaption = LayoutNameCaption.Text
            '総発行枚数を設定します。
            MLComponent.TotalQtyCaption = CInt(TotalQtyCaption.Text)
            '税率を設定します。
            MLComponent.TaxRate = TaxRate.Text
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
            '印字データタイプを設定します。
            MLComponent.PrnDataType = CType(PrnDataType.SelectedIndex, PrnDataTypes)
            '印字データを設定します。
            MLComponent.PrnData = PrnData.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        'ヘッダ札を発行
        Result = MLComponent.OutputHeader()

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("OutputHeaderでエラー発生")
        Else
            '成功
            MessageList.Items.Add("OutputHeader成功")
        End If

    End Sub

    Private Sub OutputTailButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OutputTailButton.Click

        '初期化
        MethodName.Text = "OutputTail"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        'プロパティ設定
        Try
            'ステータスIDを設定します。
            MLComponent.StatusID = CInt(StatusID.Text)
            'ジョブ名を設定します。
            MLComponent.JobName = JobName.Text
            '印字濃度を設定します。
            MLComponent.Darkness = Darkness.Text
            '印字速度を設定します。
            MLComponent.Speed = Speed.Text
            '印字補正プロパティを設定します。
            MLComponent.Offset = Offset.Text
            'カット指定を設定します。
            If MultiCut.SelectedIndex = 3 Then
                MLComponent.MultiCut = CInt(MultiCutQty.Text)
            Else
                MLComponent.MultiCut = MultiCut.SelectedIndex - 2
            End If
            '仕分けマークの印字を設定します。
            MLComponent.SortMark = SortMark.Checked
            '排出カットの印字を設定します。
            MLComponent.EjectCut = EjectCut.Checked
            'ヘッダ・テール札の印字有無を設定します。
            MLComponent.HeaderTailSetting = HeaderTailSetting.Checked
            'フォームオーバーレイを設定します。
            MLComponent.Formoverlay = CType(Formoverlay.SelectedIndex, FormoverlayTypes)
            'レイアウト名を設定します。
            MLComponent.LayoutNameCaption = LayoutNameCaption.Text
            '総発行枚数を設定します。
            MLComponent.TotalQtyCaption = CInt(TotalQtyCaption.Text)
            '税率を設定します。
            MLComponent.TaxRate = TaxRate.Text
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
            '印字データタイプを設定します。
            MLComponent.PrnDataType = CType(PrnDataType.SelectedIndex, PrnDataTypes)
            '印字データを設定します。
            MLComponent.PrnData = PrnData.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        'テール札を発行
        Result = MLComponent.OutputTail()

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("OutputTailでエラー発生")
        Else
            '成功
            MessageList.Items.Add("OutputTail成功")
        End If

    End Sub

    Private Sub SendStringDataButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendStringDataButton.Click

        Dim Type As Integer = cmbType.SelectedIndex
        Dim Length As Integer = 0
        Dim EndChar As String = txtEndChar.Text

        Try
            Length = CInt(txtLength.Text)
            If (Length < 0) Then
                Throw New ArgumentException
            End If
        Catch ex As Exception
            MessageBox.Show("バイト数の指定に誤りがあります。", "パラメータエラー", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            Return
        End Try

        '初期化
        MethodName.Text = "SendStringData"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Object
        Dim Command As String = txtSendData.Text

        'SBPLコマンドの送信
        Try
            Result = MLComponent.SendStringData(Type, Command, Length, EndChar)
        Catch ex As Exception
            MessageList.Items.Add("SendStringDataでエラー発生")
            MessageList.Items.Add(ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        MessageList.Items.Add("SendStringData成功")
        If TypeOf Result Is String Then
            Dim RecvData As String = CStr(Result)
            MessageList.Items.Add("取得データは[" & RecvData & "]です。")
        ElseIf TypeOf Result Is Byte() Then
            Dim RecvByte() As Byte = CType(Result, Byte())
            Dim RecvData As String = ""
            For Each Item As Byte In RecvByte
                If Item.ToString("X").Length = 1 Then
                    RecvData = RecvData & "0"
                End If
                RecvData = RecvData & Item.ToString("X")
            Next
            MessageList.Items.Add("取得データは[" & RecvData & "]です。")
        End If

    End Sub

    Private Sub SendRawDataButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendRawDataButton.Click

        Dim Type As Integer = cmbType.SelectedIndex
        Dim Length As Integer = 0
        Dim EndChar As String = Encoding.ASCII.GetString(FromHexString(txtEndChar.Text))

        Try
            Length = CInt(txtLength.Text)
            If (Length < 0) Then
                Throw New ArgumentException
            End If
        Catch ex As Exception
            MessageBox.Show("バイト数の指定に誤りがあります。", "パラメータエラー", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            Return
        End Try

        '初期化
        MethodName.Text = "SendRawData"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Object
        Dim Command() As Byte = FromHexString(txtSendData.Text)

        'SBPLコマンドの送信
        Try
            Result = MLComponent.SendRawData(Type, Command, Length, EndChar)
        Catch ex As Exception
            MessageList.Items.Add("SendRawDataでエラー発生")
            MessageList.Items.Add(ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        MessageList.Items.Add("SendRawData成功")
        If TypeOf Result Is String Then
            Dim RecvData As String = CStr(Result)
            MessageList.Items.Add("取得データは[" & RecvData & "]です。")
        ElseIf TypeOf Result Is Byte() Then
            Dim RecvByte() As Byte = CType(Result, Byte())
            Dim RecvData As String = ""
            For Each Item As Byte In RecvByte
                If Item.ToString("X").Length = 1 Then
                    RecvData = RecvData & "0"
                End If
                RecvData = RecvData & Item.ToString("X")
            Next
            MessageList.Items.Add("取得データは[" & RecvData & "]です。")
        End If

    End Sub

    Public Shared Function FromHexString(str As String) As Byte()
        Dim length As Integer = str.Length \ 2
        Dim bytes As Byte() = New Byte(length - 1) {}
        Dim j As Integer = 0
        For i As Integer = 0 To length - 1
            bytes(i) = Convert.ToByte(str.Substring(j, 2), 16)
            j += 2
        Next
        Return bytes
    End Function

    Private Sub GetStatusButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GetStatusButton.Click

        '初期化
        MethodName.Text = "GetStatus"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer
        Dim Status As String = ""

        'プリンタの状態確認
        Result = MLComponent.GetStatus(Status)

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("GetStatusでエラー発生")
        Else
            '成功
            MessageList.Items.Add("ステータスは[" & Status & "]です。")
        End If

    End Sub

    Private Sub CutButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CutButton.Click

        '初期化
        MethodName.Text = "Cut"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        'プロパティ設定
        Try
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        '用紙の排出カット
        Result = MLComponent.Cut()

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("Cutでエラー発生")
        Else
            '成功
            MessageList.Items.Add("Cut成功")
        End If

    End Sub

    Private Sub SendCancelButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendCancelButton.Click

        '初期化
        MethodName.Text = "SendCancel"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        '発行のキャンセル
        Result = MLComponent.SendCancel()

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("SendCancelでエラー発生")
        Else
            '成功
            MessageList.Items.Add("SendCancel成功")
        End If

    End Sub

    Private Sub GetInputFieldsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GetInputFieldsButton.Click

        '初期化
        MethodName.Text = "GetInputFields"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer
        Dim InputCount As Integer
        Dim InputStatus As Object = Nothing

        'プロパティ設定
        Try
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        '入力情報を取得
        Result = MLComponent.GetInputFields(InputCount, InputStatus)

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("GetInputFieldsでエラー発生")
        Else
            '成功
            MessageList.Items.Add("項目数は[" & CStr(InputCount) & "]です。")
            If TypeOf InputStatus Is String() Then
                Dim Fields() As String = CType(InputStatus, String())
                For Each Item As String In Fields
                    MessageList.Items.Add(Item)
                Next
            End If
        End If

    End Sub

    Private Sub SetPrnDataButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetPrnDataButton.Click

        '初期化
        MethodName.Text = "SetPrnDataField"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer

        'プロパティ設定
        Try
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        '印字データを設定
        '以下の例は当サンプル「layout1.mllayx」の場合の記述例です。ご利用のレイアウトに合わせて書き換えてください。
        Result = MLComponent.SetPrnDataField("入力-1", "ABC")

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("SetPrnDataFieldでエラー発生")
        Else
            '成功
            MessageList.Items.Add("SetPrnDataField成功")
        End If

    End Sub

    Private Sub SetPrnDataArrayButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetPrnDataArrayButton.Click

        '初期化
        MethodName.Text = "SetPrnDataArray"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer
        Dim PrnDataArray() As String = Nothing

        'プロパティ設定
        Try
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        Dim Separator As String = vbTab
        If PrnDataType.SelectedIndex = 1 Then
            Separator = ","
        ElseIf PrnDataType.SelectedIndex = 2 Then
            Separator = " "
        End If

        '以下の例は当サンプル「layout1.mllayx」の場合の記述例です。ご利用のレイアウトに合わせて書き換えてください。
        ReDim PrnDataArray(2)
        PrnDataArray(0) = "ABC" & Separator & "1"
        PrnDataArray(1) = "EFG" & Separator & "1"
        PrnDataArray(2) = "123" & Separator & "2"

        '印字データを設定
        Result = MLComponent.SetPrnDataArray(PrnDataArray)

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("SetPrnDataArrayでエラー発生")
        Else
            '成功
            MessageList.Items.Add("SetPrnDataArray成功")
        End If

    End Sub

    Private Sub GetPrnDataArrayButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GetPrnDataArrayButton.Click

        '初期化
        MethodName.Text = "GetPrnDataArray"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim PrnDataArray() As String

        '印字データを取得
        PrnDataArray = MLComponent.GetPrnDataArray()

        If IsNothing(PrnDataArray) Then
            '失敗
            MessageList.Items.Add("GetPrnDataArrayでエラー発生")
        ElseIf PrnDataArray.Length = 0 Then
            '失敗
            MessageList.Items.Add("GetPrnDataArrayでエラー発生")
        Else
            '成功
            MessageList.Items.Add("データ数は[" & CStr(PrnDataArray.Length) & "]です。")
            For Each Item As String In PrnDataArray
                MessageList.Items.Add(Item)
            Next
        End If

    End Sub

    Private Sub GetPrinter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GetPrinter.Click

        '初期化
        MethodName.Text = "GetPrinter"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim PrinterModel As String

        'プロパティ設定
        Try
            'レイアウトファイルを設定します。
            MLComponent.LayoutFile = LayoutFile.Text
        Catch ex As Exception
            MessageList.Items.Add("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Return
        End Try

        'プリンタ情報を取得
        PrinterModel = MLComponent.GetPrinter()

        If String.IsNullOrEmpty(PrinterModel) Then
            '失敗
            MessageList.Items.Add("GetPrinterでエラー発生")
        Else
            '成功
            MessageList.Items.Add("プリンタは[" & PrinterModel & "]です。")
        End If

    End Sub

    Private Sub DataInfo_Click(sender As System.Object, e As System.EventArgs) Handles DataInfo.Click
        Dim message As String = ""
        message += "送信データ・受信終了キャラクタは以下の形式で指定してください。" & vbCrLf
        message += "SendStringData：文字列" & vbCrLf
        message += "SendRawData：16進文字列" & vbCrLf & vbCrLf
        message += "例：文字列[0310]は、16進文字列[30333130]です。"
        MessageBox.Show(message, "[SendStringData/SendRawData]", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
    End Sub

    Private Sub btnSearchBTDevice_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSearchBTDevice.Click

        '初期化
        MethodName.Text = "EnumerateBluetoothDevices"
        MethodResult.Text = ""
        MessageList.Items.Clear()
        cmbBTDevice.Items.Clear()

        Dim arrayVar As Object
        Dim SearchTime As Integer = 3

        MessageList.Items.Add("=====デバイス検索開始=====")
        Application.DoEvents()

        'Bluetoothデバイス検索
        arrayVar = MLComponent.EnumerateBluetoothDevices(SearchTime)

        Dim DevArray As Object(,) = CType(arrayVar, Object(,))
        For n = DevArray.GetLowerBound(0) To DevArray.GetUpperBound(0)
            Dim address As String = CType(DevArray(n, 0), String)
            Dim name As String = CType(DevArray(n, 1), String)
            Dim isauth As String = CType(DevArray(n, 2), String)
            MessageList.Items.Add(" " & address & ", " & name & ", " & isauth)
            cmbBTDevice.Items.Add(address)
        Next

        MessageList.Items.Add("=====デバイス検索終了=====")

    End Sub

    Private Sub btnPairingBTDevice_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPairingBTDevice.Click

        '初期化
        MethodName.Text = "AuthenticateBluetoothDevice"
        MethodResult.Text = ""
        MessageList.Items.Clear()

        Dim Result As Integer
        Dim Address As String = cmbBTDevice.Text
        Dim PIN As String = PINCode.Text
        Dim SearchTime As Integer = 3

        'Bluetoothデバイスペアリング
        Result = MLComponent.AuthenticateBluetoothDevice(Address, PIN, SearchTime)

        MethodResult.Text = CStr(Result)

        If Result <> 0 Then
            '失敗
            MessageList.Items.Add("AuthenticateBluetoothDeviceでエラー発生")
        Else
            '成功
            MessageList.Items.Add("AuthenticateBluetoothDevice成功")
        End If

    End Sub
End Class
