Imports System.IO
Imports System.Text
Imports SATO.MLComponent

Public Class Form1

    Private MLComponent As MLComponent
    Private RecDatas As ArrayList

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        OpenFileDialog1.Filter = "レイアウトファイル (*.mllayx)|*.mllayx|すべてのファイル (*.*)|*.*"
        OpenFileDialog1.FileName = ""
        If OpenFileDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            LayoutFileName.Text = OpenFileDialog1.FileName
        End If
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        OpenFileDialog1.Filter = "テキスト(タブ区切り) (*.txt)|*.txt|すべてのファイル (*.*)|*.*"
        OpenFileDialog1.FileName = ""
        If OpenFileDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            DataFileName.Text = OpenFileDialog1.FileName
        End If
    End Sub

    Private Sub ReadDataFile()
        Dim strm As Stream
        strm = File.OpenRead(DataFileName.Text)
        Dim sr As StreamReader = New StreamReader(strm, System.Text.Encoding.Default)

        sr.BaseStream.Seek(0, SeekOrigin.Begin)
        While (sr.Peek() > -1)
            RecDatas.Add(sr.ReadLine())
        End While
        sr.Close()

    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Dim ret As Long   '関数の実行結果
        Dim recNum As Long           'レコード番号
        Try
            '通信設定プロパティの設定
            MLComponent.Setting = Setting.Text
            'タイムアウト値を設定（ここでは3秒）
            MLComponent.Timeout = 3
            '通信プロトコルの設定
            MLComponent.Protocol = CType(Protocol.SelectedIndex, Protocols)
            'レイアウトファイルの設定
            MLComponent.LayoutFile = LayoutFileName.Text
        Catch ex As Exception
            MsgBox("プロパティ設定で例外発生 " & ex.Message.Replace(vbCrLf, " "))
            Exit Sub
        End Try
        ret = MLComponent.OpenPort(1)
        If ret <> 0 Then
            MsgBox("OpenPortでエラー発生, ret=" & ret)
            Exit Sub
        End If
        'コレクションオブジェクト生成します。(データ格納用)
        RecDatas = New ArrayList

        'ファイルからデータを読み込みます。
        ReadDataFile()

        StatusText.Text = ""
        For recNum = 1 To RecDatas.Count()
            'プリンタが受信可能になるまで待ちます。
            '本処理を省略すると、紙切れやエラー時にデータを送信し、ラベル抜けが発生します。
            'データ送信前の状態確認は必ず行い、運用に応じて送信後の状態確認も行ってください。
            If PrinterReadyWait() = False Then
                Call MLComponent.ClosePort()
                Exit Sub
            End If
            '発行します。
            MLComponent.PrnData = CStr(RecDatas.Item(CInt(recNum - 1)))
            StatusText.Text = "印字中"
            ret = MLComponent.Output()
            If ret <> 0 Then
                Call MLComponent.ClosePort()
                MsgBox("Output Error, ret=" & ret)
                Exit Sub
            End If
            My.Application.DoEvents()
        Next recNum
        'データ格納用コレクションオブジェクトを破棄します。
        RecDatas = Nothing
        '印字が完了するまでWait
        PrinterReadyWait()
        Call MLComponent.ClosePort()
        StatusText.Text = ""
    End Sub

    Private Function PrinterReadyWait() As Boolean
        Dim Status As String
        Dim ret As Integer '関数の実行結果
        Dim strSetting As String
        strSetting = MLComponent.Setting.Substring(0, 4)
        '出力先がドライバ、ファイルの場合ステータスチェックを行わない
        If (strSetting <> "DRV:") And (strSetting <> "FILE") Then
            Status = ""
            While (Status <> "A000000") And (Status <> "B000000")
                ret = MLComponent.GetStatus(Status)
                If ret = 0 Then
                    StatusText.Text = Status
                Else
                    MsgBox("ステータス応答がありません。ret=" & ret)
                    Return False
                End If
                '受信ステータスからステータスと残り枚数の部分を取り出す
                Status = Status.Substring(2, 7)
                My.Application.DoEvents()
            End While
        End If
        Return True
    End Function

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load

        'MLComponent生成
        MLComponent = New MLComponent

        'コンボボックスに通信設定例を列挙します。
        Setting.Items.Add(("LAN:127.0.0.1"))
        Setting.Items.Add(("USB:"))
        Setting.Items.Add(("COM1:57600,n,8,1"))
        Setting.Items.Add(("BT:000b5d3db4c2"))
        Setting.Items.Add(("DRV:SATO CL4NX-J 305dpi"))
        Setting.Items.Add(("FILE:C:\\sato\print.prn,0"))
        Setting.Text = MLComponent.Setting

        'コンボボックスにプロトコルを列挙します。
        Protocol.Items.Add(("0 - Status3"))
        Protocol.Items.Add(("1 - Status4"))
        Protocol.SelectedIndex = 0

    End Sub
End Class
